IF EXISTS (SELECT  *  FROM  sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[UFD_DIAGNOSTICO_RESSUP]') AND type IN ( N'TF' ))
    BEGIN
	   DROP FUNCTION [dbo].[UFD_DIAGNOSTICO_RESSUP]
    END

GO

SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO

/***********************************************************************************/
--Principais bloqueios de ressuprimento
/***********************************************************************************/

--select * from [dbo].[UFD_DIAGNOSTICO_RESSUP] (1,2,998,5345)
CREATE  FUNCTION [dbo].[UFD_DIAGNOSTICO_RESSUP](@cd_emp		INT,
										   @Filial		 INT ,
										   @FilialCD		INT,
										   @Produto		INT)

RETURNS @RsRet table(Produto int ,
						FilialDeposito int,
						FilialDestino int, 
						Estoque int,
						EstoqueDeposito int,
						Emax int,
						Eseg int,
						DescricaoProblema varchar(300))
    
AS
BEGIN

/***********************************************************************************/
--Variaveis auxiliares
/***********************************************************************************/
declare @diagnostico TABLE(DescricaoProblema varchar(300)); 

declare @DiaSemana tinyint, 
		  @DiaRessuprimento date,  
		  @UltimoRessuprimento date,  
		  @Linha int,
		  @Fabricante int, 
		  @GrpRessup int,
		  @Deposito int,
		  @CdAux tinyint,
		  @QtUniRessup Money,
		  @QtEstDeposito Money;


set @DiaRessuprimento = (select getdate());
set @DiaSemana =datepart(weekday,@DiaRessuprimento);

select @Deposito=CD_CTR_DEPO,	  
	  @CdAux= CASE WHEN DEPOSITO_AUXILIAR='SIM' THEN 1 ELSE 0 END
from 
    v_prc_filial_relacao_depositos 
where CD_CTR_DEPO=@FilialCD;

set @Linha = (select cd_arv_merc_linha from est_prod_est_arv_mercadologica 
				    where cd_emp=@cd_emp and cd_prod=@Produto);
set @Fabricante=(select cd_fabric from est_prod 
				    where cd_emp=@cd_emp and cd_prod=@Produto);
set @GrpRessup	= (select top 1 cd_grp_res From V_EST_ARV_GRP_RESSUPRIMENTO 
				    where 
					   cd_emp=@cd_emp 
					   and cd_filial =@filial 
					   and cd_arv_merc_linha = @Linha);


/***********************************************************************************/
--Validacoes
/***********************************************************************************/
 
--linha por dia da semana
if exists(select * From 
				EST_ARV_GRP_RESSUPRIMENTO_NAO_EXECUTAR_DIA_SEMANA_PRC_FILIAL_LINHA
		where dia_Semana=@DiaSemana and cd_Arv_merc_linha=@Linha and cd_filial=@filial )
begin 
    insert into @Diagnostico
    select  'Filial por linha bloqueada para o dia da semana solicitado' 
end

if exists(select * From 
				EST_ARV_GRP_RESSUPRIMENTO_NAO_EXECUTAR_LINHA_DIA_SEMANA
		where dia_Semana=@DiaSemana and cd_Arv_merc_linha=@Linha    )
begin     
    insert into @Diagnostico
    select   'Linha bloqueada para o dia da semana solicitado'
     
end

if exists(select * From 
				EST_ARV_GRP_RESSUPRIMENTO_NAO_EXECUTAR_FABRIC_DIA_SEMANA
		where dia_Semana=@DiaSemana and cd_fabric=@Fabricante   )
begin     
    insert into @Diagnostico
    select   'Fabricante bloqueado para o dia da semana solicitado'
     
end

if exists(select * From 
				EST_ARV_GRP_RESSUPRIMENTO_NAO_EXECUTAR_DIA_SEMANA_PRC_FILIAL				
		where dia_Semana=@DiaSemana and cd_Filial =@Filial )
begin     
    insert into @Diagnostico
    select   'Filial bloqueada para o dia da semana solicitado'
     
end

if exists(select * From 
				EST_ARV_GRP_RESSUPRIMENTO_NAO_EXECUTAR_FILIAL
				
		where DT_NAO_RESSUP=@DiaRessuprimento and cd_Filial =@Filial )
begin     
    insert into @Diagnostico
    select   'Filial bloqueada para o data solicitada'     
end


if exists(select * From 
				EST_ARV_GRP_RESSUPRIMENTO_NAO_EXECUTAR				
		where DT_NAO_RESSUP=@DiaRessuprimento and CD_GRP_RES=@GrpRessup )
begin     
    insert into @Diagnostico
    select   'Grupo de ressuprimento bloqueado para o data solicitada'     
end

if not exists(select * From 
				EST_PROD 
		where CD_EMP=@cd_emp and cd_prod=@Produto  and sts_prod =0 )
begin     
    insert into @Diagnostico
    select   'Produto Inexistente, bloqueado ou inativo' 
end

if exists(select * From 
				EST_PROD_CPL
		where CD_EMP=@cd_emp 
			 and cd_prod=@Produto 
			 and cd_Filial =@Filial 
			 and sts_prod!=0 )
begin     
    insert into @Diagnostico
    select   'Produto bloqueado ou inativo' 
end

if exists(select * From 
				EST_PROD_CPL
		where CD_EMP=@cd_emp 
			 and cd_prod   =@Produto 
			 and cd_Filial =@FilialCD 
			 and (Prat + Gav)= 0 )
begin     
    insert into @Diagnostico
    select   'Produto sem configuracao de endereco ' 
end

 
if not exists(select * From 
				EST_PROD_CPL s 
				join EST_PROD_PRT_GRP_RESSUPRIMENTO_CPL r on 
				s.CD_EMP = r.cd_emp and
				s.prat = r.CD_PRT
			where	 s.CD_EMP=@cd_emp 
				 and s.cd_prod=@Produto 
				 and s.cd_Filial =@FilialCD 
			   )
begin     
    insert into @Diagnostico
    select   'Configuracao grupo ressuprimento/prateleira nao encontrado' 
end



/***********************************************************************************/
-- Validacao da demanda 
/***********************************************************************************/
Declare @Estoque money, @Emax money, @Eseg money;

select
    @Estoque =qt_est_pend, 
    @Emax =dbo.UFD_EST_AJUSTA_Emax(QTDE_FACEAMENTO, GETDATE(), QTDE_FINANCIADO, QTDE_LIMITADOR, (EMAX*(MEDIAF/30))), 
    @Eseg =dbo.UFD_EST_AJUSTA_ESEG(QTDE_FACEAMENTO_REPOSICAO, GETDATE(), QTDE_FINANCIADO, (ESEG*(MEDIAF/30)))
From 
    V_EST_PROD_CPL_ESTOQUE
where 
    CD_EMP=@cd_emp 
    and cd_prod=@Produto 
    and cd_Filial =@Filial 
    and sts_prod=0 ;

if @Estoque > @Eseg
    begin     
	   insert into @Diagnostico
	   select   'Estoque do produto e maior que o Eseg' 
    end

if @Estoque > @Emax
    begin     
	   insert into @Diagnostico
	   select   'Estoque do produto e maior que o Emax' 
    end

Set  @QtEstDeposito  = Isnull((select qt_est_pend From  V_EST_PROD_CPL_ESTOQUE
							where 
									CD_EMP=@cd_emp 
									and cd_prod=@Produto
									and cd_filial=@FilialCD  
									and sts_prod=0 
									),0);

If @QtEstDeposito < 1
begin     
    insert into @Diagnostico
    select   'Produto sem estoque disponivel no CD' 
end

/***********************************************************************************/
IF @Estoque < @Emax
   AND @Estoque < @Eseg
    BEGIN
        SET @QtUniRessup = isnull((SELECT QT_UNI_RESSUPRIMENTO FROM est_prod
														WHERE QT_UNI_RESSUPRIMENTO > 0
														  AND FLAG_RESSUPRIMENTO_CAIXA_FECHADA = 1
														  AND cd_prod = @Produto
												), 1);
        IF @QtUniRessup > 1
            BEGIN
                IF ROUND((@Estoque - @Emax) / @QtUniRessup, 0) = 0
                    BEGIN
                        INSERT INTO @Diagnostico
                               SELECT
                                      'Produto com ressuprimento caixa fechada, sem demanda para fechar uma caixa - '+CONVERT(VARCHAR, @QtUniRessup);
                    END;
            END;
    END;
/***********************************************************************************/
--Validacaos se o produto pertence a algum deposito auxiliar..
if @CdAux>0
    begin
	   if not exists( SELECT 
				    CD_EMP,
				    CD_PROD 
				FROM 
				    PRC_FILIAL_DEPOSITO_AUXILIAR_EST_PROD  
				WHERE
				    CD_CTR_DEPO = @Deposito
				    AND CD_FILIAL_DEPO_AUX=@FilialCD
				    and cd_prod=@Produto)
	   begin
		  if not exists( SELECT DISTINCT 
							    CD_EMP,
							    CD_PROD 
						    FROM 
							    PRC_FILIAL_DEPOSITO_AUXILIAR_EST_PROD_CPL
						    WHERE
							    CD_FILIAL = @filial
							    AND CD_CTR_DEPO=@Deposito
							    and cd_prod=@Produto
							    AND CD_FILIAL_DEPO_AUX=@FilialCD )
		  begin
			 insert into @Diagnostico
			 select   'Produto nao e atendido por este deposito' 
		  end
	   end
    end
else
    begin 
	   if exists( SELECT 
				    CD_EMP,
				    CD_PROD 
				FROM 
				    PRC_FILIAL_DEPOSITO_AUXILIAR_EST_PROD  
				WHERE
				    CD_CTR_DEPO = @Deposito
				    AND CD_FILIAL_DEPO_AUX=@FilialCD
				    and cd_prod=@Produto)
	   begin
		  insert into @Diagnostico
		  select   'Produto nao e atendido por este deposito' 
	   end

	   if exists( SELECT DISTINCT 
							 CD_EMP,
							 CD_PROD 
						  FROM 
							 PRC_FILIAL_DEPOSITO_AUXILIAR_EST_PROD_CPL
						  WHERE
							 CD_FILIAL = @filial
							 AND CD_CTR_DEPO=@Deposito
							 and cd_prod=@Produto
							 AND CD_FILIAL_DEPO_AUX=@FilialCD )
	   begin
		  insert into @Diagnostico
		  select   'Produto nao e atendido por este deposito' 
	   end  
    end
/************************************************************************************/
--Validar o agendamento
/************************************************************************************/
Declare @Agendamento tinyint;

SET @Agendamento  = ISNULL((SELECT VALOR FROM PRC_EMP_CONFIG 
						  WHERE CD_EMP = @CD_EMP 
							 AND CD_CHAVE = 'UTILIZA_AGD_RESSUPRIMENTO'),0);
 
if @Agendamento =0
begin
	SET @Agendamento = ISNULL((SELECT VALOR FROM PRC_FILIAL_CONFIG 
						  WHERE CD_EMP = @CD_EMP AND CD_CHAVE = 'UTILIZA_AGD_RESSUPRIMENTO'  
						  AND CD_FILIAL=@FilialCD),0);
end 

if @Agendamento>0
begin
    if not exists(
	   SELECT  *
		FROM  
			EST_PROD_RESSUP_AGENDAMENTO A
			INNER JOIN EST_PROD_RESSUP_AGENDAMENTO_PRC_FILIAL p on
			A.CD_EMP		= P.CD_EMP AND
			A.CD_AGD_RESSUP  = P.CD_AGD_RESSUP
	    
			INNER JOIN EST_PROD_RESSUP_AGENDAMENTO_EST_PROD_FABRIC f on
			A.CD_EMP		= F.CD_EMP AND
			A.CD_AGD_RESSUP  = F.CD_AGD_RESSUP
	
			INNER JOIN EST_PROD_RESSUP_AGENDAMENTO_EST_ARV_MERC_LINHA l on
			A.CD_EMP		= L.CD_EMP AND
			A.CD_AGD_RESSUP  = L.CD_AGD_RESSUP 
			INNER JOIN EST_PROD Y on 
			F.CD_FABRIC  = Y.CD_FABRIC 

			INNER JOIN EST_PROD_EST_ARV_MERCADOLOGICA W on
			L.CD_EMP			 = W.CD_EMP AND
			L.CD_ARV_MERC_LINHA  = W.CD_ARV_MERC_LINHA AND
			Y.CD_PROD			 = W.CD_PROD
		WHERE
			A.CD_EMP	= @CD_EMP
			AND A.CD_FILIAL_DEPO	= @FilialCD 
			AND	(CASE WHEN @DiaSemana =1 THEN A.DOMINGO
					WHEN @DiaSemana =2 THEN A.SEGUNDA  
					WHEN @DiaSemana =3 THEN A.TERCA  
					WHEN @DiaSemana =4 THEN A.QUARTA
					WHEN @DiaSemana =5 THEN A.QUINTA  
					WHEN @DiaSemana =6 THEN A.SEXTA  
					WHEN @DiaSemana =7 THEN A.SABADO END) = 1 
			and w.cd_prod=@Produto)
		 begin
			 if not exists(SELECT * 
						    FROM	 
							    (SELECT DISTINCT
									    T.CD_EMP,
									    P.CD_PROD,
									    F.CD_FILIAL
								    FROM 
									    EST_PROD_TABLOIDE T
									    INNER JOIN EST_PROD_TABLOIDE_CPL P ON 
									    T.CD_EMP = P.CD_EMP AND
									    T.CD_TABLOIDE = P.CD_TABLOIDE
									    INNER JOIN EST_PROD_TABLOIDE_FILIAL F ON 
									    T.CD_EMP		= F.CD_EMP AND
									    T.CD_TABLOIDE	= F.CD_TABLOIDE
								    WHERE T.FLAG_VIGENCIA=1
									   and p.cd_prod=@Produto) T
							    LEFT JOIN EST_PROD_TRANSF_AGENDAMENTO TA ON 
							    T.CD_EMP	= TA.CD_EMP AND
							    T.CD_PROD	= TA.CD_PROD AND
							    T.CD_FILIAL= TA.CD_FILIAL 
							    INNER JOIN EST_PROD_RESSUP_AGENDAMENTO A ON 
							    T.CD_EMP	= A.CD_EMP  
						    WHERE
							    A.CD_EMP	= @CD_EMP
							    AND TA.CD_EMP IS NULL
							    AND A.INCLUI_TABLOIDE=1
							    AND A.CD_FILIAL_DEPO	= @FilialCD 
							    AND (CASE WHEN @DiaSemana =1 THEN A.DOMINGO
								    WHEN @DiaSemana =2 THEN A.SEGUNDA  
								    WHEN @DiaSemana =3 THEN A.TERCA  
								    WHEN @DiaSemana =4 THEN A.QUARTA
								    WHEN @DiaSemana =5 THEN A.QUINTA  
								    WHEN @DiaSemana =6 THEN A.SEXTA  
								    WHEN @DiaSemana =7 THEN A.SABADO END) = 1)
		  begin
			 insert into @Diagnostico
			 select   'Produto nao tem agendamento para o dia de hoje'
		  end
	   end

   end


   Set @UltimoRessuprimento = Isnull((SELECT MAX(DT_TRANSF)
									FROM
										 est_prod_transf t
										 JOIN est_prod_transf_it i ON t.cd_emp = i.cd_emp
																	  AND t.cd_filial = i.cd_filial
																	  AND t.cd_ctr = i.cd_ctr
									WHERE	  t.cd_emp = @cd_emp
										  AND i.cd_prod = @Produto
										  and t.cd_filial =@FilialCD
										  and t.cd_fil_dest =@Filial),'2001-01-01')
	Insert into @Diagnostico
	select   'Ultimo ressuprimento do produto em ' + convert(varchar, @UltimoRessuprimento,112)
	

/***********************************************************************************/
--Resultado final
/***********************************************************************************/
    INSERT INTO @RsRet
    select 
	   @Produto Produto ,
	   @filialCd FilialDeposito,
	   @Filial  FilialDestino, 
	   @Estoque Estoque,
	   @QtEstDeposito EstCd,
	   @Emax Emax,
	   @Eseg Eseg,
	   DescricaoProblema 
    from 
	   @diagnostico

    return;
/***********************************************************************************/
 end